﻿using System;
using System.ServiceModel;
using VA.TMP.Integration.VIMT.HealthShare.Mappers;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.UpdateClinic
{
    /// <summary>
    /// Map Clinic to CRM etities step.
    /// </summary>
    public class MapClinicStep : FilterBase<UpdateClinicStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(UpdateClinicStateObject state)
        {
            try
            {
                state.Clinic = new UpdateClinicMapper(state.RequestMessage, state.OrganizationServiceProxy).Map();
            }
            catch (FaultException ex)
            {
                throw new Exception($"HealthShare Update Clinic MapClinicStep Pipeline Error: {ex.Message}", ex.InnerException);
            }
            catch (Exception ex)
            {
                throw new Exception(string.Format("HealthShare Update Clinic MapClinicStep Pipeline Error: {0}", ex.Message), ex.InnerException);
            }
        }
    }
}